# iOS SDK


## 統合手順

1.手動インポート：` HYTTS.framework `をプロジェクトにドラッグします。その後、` Gneral->Framewoksで、Libraries，and Embedded Content `の下で‘HYTTS.framework’の‘Embed’を‘Embed&Sign’に変更します。

2. podにSocketRocket 0.6.0、AFNetworking, SSZipArchive 2.4.3。

###  関連権限の適用の追加
1.プロジェクトの` info.plist `ファイルに` Privacy-Microphone Usage Description `を追加して、マイクアクセス権を追加します。


### 呼び出しステップ/サンプルコード

#### インスタンスの取得

- ` TTS `のインスタンスを取得する

```
    TTSParams *params = [[TTSParams alloc] init];
    params.langType = @"";
    [[TTSManger shareInstance] setSdkParams:params]
    [[TTSManger shareInstance] initWithWithAppid:@"" WithAppSecret:@"" WithinitBlock:^(NSError * _Nonnull Error) {
        
        if (Error == nil) {
            NSLog(@"初期化に成功しました");
        }
        
    }];
   
```

#### 認証の有効化

（1）認証パラメータの構成
|名前|タイプ|説明|デフォルト値|
|-------|-------|-------|-------|
|online|string|true，false|true|



```
    TTSParams *parames = [[TTSManger getTTSManger] getSdkParams];
    params.online = @"true";

```


#### パラメータ設定
|パラメータ|タイプ|必須かどうか|説明|デフォルト値|
|-------|-------|-------|-------|-------|
|text|String|はい|合成対象テキスト|必須|
|lang_type|String|はい|言語オプション|必須|
|voice|String|いいえ|音色オプション|なし|
|format|String|いいえ|オーディオコーディングフォーマット|pcm|
|sample_rate|Integer|いいえ|オーディオサンプリングレート|24000|
|volume|Integer|いいえ|音量、[0.1、3]、デフォルトは1で、通常は小数点以下の1桁を残してください|1|
|speech_rate|Float|いいえ|[0.2、3]のデフォルトは1で、通常は小数点以下の1桁を保持してください|1.0|
|pitch_rate|Float|いいえ|イントネーション、[0.1、3][0.1、3]、デフォルトは1で、通常は小数点以下の1桁を保持すればよい|1|
|emotion|String|いいえ|感情的なスタイル|无|
|silence_duration|Integer|いいえ|文末無音時間|なし|

```

TTSParams *params = [[TTSParams alloc] init]; params.text = @"";
params.langType = @"";
params.format = @"pcm";
params.voice = @"xiaohui";
params.volume = 50;
params.speech_rate = 1;
params.pitch_rate = 0;
params.sample_rate = 16000;
[[TTSManger shareInstance] setSdkParams:params];

```
#### 合成の開始/停止

```
TTSParams *parames = [[TTSManger getTTSManger] getSdkParams];
parames.text = @"";
[[TTSManger getTTSManger] onStart];
[[TTSManger getTTSManger] onStop]; 
```

## ステータスコードテーブル

| エラーコード | エラーメッセージ             | ソリューション                                           |
| ------ | -------------------- | ---------------------------- |
| 110002 | コンピテンシーが認可されていません     | 承認されたコンピテンシーに変更するか、ビジネスに連絡してAI能力を追加する    |
| 110003 | appid期限切れ        | ビジネスに連絡するappidの有効期間を増やす  |
| 110004 | よびだしオーバーラン   | ビジネスに連絡してライセンス回数を増やす     |
| 110005 | 同時超過             | ビジネス追加合併に連絡する            |
| 300000 | パラメータエラー       | チェックパラメータ |
| 300001 | パラメータがありません   | 必須パラメータがありません             |
| 300004 | 合成テキストが空です         | 合成テキストがありません          |
| 300005 | 合成テキスト長の限界超過     | 合成音声のテキスト、長さ制限1024バイト   |
| 300100 | 合成しています。後で再試行してください | 合成完了後の操作           |
| 300101 | 再生中です。後で再試行してください | 再生が完了したら操作           |
